// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/devices_app/usb/public/interfaces/device.mojom
//

package org.chromium.mojom.device.usb;

public interface Device extends org.chromium.mojo.bindings.Interface {

    public interface Proxy extends Device, org.chromium.mojo.bindings.Interface.Proxy {
    }

    Manager<Device, Device.Proxy> MANAGER = Device_Internal.MANAGER;

    void getDeviceInfo(GetDeviceInfoResponse callback);
    interface GetDeviceInfoResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<DeviceInfo> { }

    void getConfiguration(GetConfigurationResponse callback);
    interface GetConfigurationResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Byte> { }

    void open(OpenResponse callback);
    interface OpenResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Integer> { }

    void close(CloseResponse callback);
    interface CloseResponse extends org.chromium.mojo.bindings.Callbacks.Callback0 { }

    void setConfiguration(byte value, SetConfigurationResponse callback);
    interface SetConfigurationResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void claimInterface(byte interfaceNumber, ClaimInterfaceResponse callback);
    interface ClaimInterfaceResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void releaseInterface(byte interfaceNumber, ReleaseInterfaceResponse callback);
    interface ReleaseInterfaceResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void setInterfaceAlternateSetting(byte interfaceNumber, byte alternateSetting, SetInterfaceAlternateSettingResponse callback);
    interface SetInterfaceAlternateSettingResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void reset(ResetResponse callback);
    interface ResetResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void clearHalt(byte endpoint, ClearHaltResponse callback);
    interface ClearHaltResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void controlTransferIn(ControlTransferParams params, int length, int timeout, ControlTransferInResponse callback);
    interface ControlTransferInResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, byte[]> { }

    void controlTransferOut(ControlTransferParams params, byte[] data, int timeout, ControlTransferOutResponse callback);
    interface ControlTransferOutResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Integer> { }

    void genericTransferIn(byte endpointNumber, int length, int timeout, GenericTransferInResponse callback);
    interface GenericTransferInResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, byte[]> { }

    void genericTransferOut(byte endpointNumber, byte[] data, int timeout, GenericTransferOutResponse callback);
    interface GenericTransferOutResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Integer> { }

    void isochronousTransferIn(byte endpointNumber, int numPackets, int packetLength, int timeout, IsochronousTransferInResponse callback);
    interface IsochronousTransferInResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, byte[][]> { }

    void isochronousTransferOut(byte endpointNumber, byte[][] packets, int timeout, IsochronousTransferOutResponse callback);
    interface IsochronousTransferOutResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Integer> { }
}

